<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Contributte\Translation\Translator;
use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\Model\Navigation\Home;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Nette\Caching\Cache;
use Nette\SmartObject;

class ProductTextListener implements EventSubscriberInterface
{
	use SmartObject;

	protected static array $cleared = [];

	protected CacheService $cacheService;
	protected Translator $translator;

	public function __construct(Translator $translator, CacheService $cacheService)
	{
		$this->cacheService = $cacheService;
		$this->translator   = $translator;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PreFlush
	 *
	 * @param ProductTexts       $productText
	 */
	public function onPreFlush($productText, Doctrine\ORM\Event\PreFlushEventArgs $args): void
	{
		if (!self::$cleared[$productText->getProduct()->getId()]) {
			$this->cacheService->clean('product', [
				Cache::TAGS => [
					'product/' . $productText->getProduct()->getId(),
				],
			]);
			$this->cacheService->clean('navigation', [
				Cache::TAGS => [
					Home::CACHE_PRODUCT . '/' . $productText->getProduct()->getId(),
				],
			]);
		}

		self::$cleared[$productText->getProduct()->getId()] = true;
	}

}