<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TTranslateListener;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/**
 * @ORM\Entity
 * @ORM\Table(name="eshop_catalog__supplier")
 * @ORM\EntityListeners({"Core\Model\Entities\TranslateListener"})
 */
class Supplier
{
	use TId;
	use TTranslateListener;

	/**
	 * @ORM\Column(type="string", nullable=false)
	 */
	public string $name;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $logo = null;

	/**
	 * @var int|bool
	 * @ORM\Column(type="smallint", length=1)
	 */
	public $isPublished;

	/**
	 * @ORM\Column(type="smallint", length=1, options={"default": 1})
	 */
	public int $allowSale = 1;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $website = null;

	/**
	 * @var Collection<string, SupplierTexts>
	 * @ORM\OneToMany(targetEntity="SupplierTexts", mappedBy="id", indexBy="lang", cascade={"all"})
	 */
	protected Collection $supplierTexts;

	/**
	 * @var Collection<string, ProductSupplier>
	 * @ORM\OneToMany(targetEntity="ProductSupplier", mappedBy="supplier", orphanRemoval=true, cascade={"persist", "remove"})
	 */
	protected Collection $products;

	public function __construct(string $name)
	{
		$this->name          = $name;
		$this->products      = new ArrayCollection;
		$this->supplierTexts = new ArrayCollection;
		$this->isPublished   = 0;
	}

	public function addSupplierText(string $lang): void
	{
		$this->supplierTexts->set($lang, new SupplierTexts($this, $lang));
	}

	public function setSupplierText(SupplierTexts $supplierTexts): void
	{
		$this->supplierTexts->set($supplierTexts->getLang(), $supplierTexts);
	}

	public function getSupplierText(?string $lang = null): ?SupplierTexts
	{
		return $this->supplierTexts->get($lang ?: $this->locale);
	}

}
