<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TTranslateListener;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/**
 * @ORM\Table(name="eshop_catalog__tag")
 * @ORM\Entity
 * @ORM\EntityListeners({"Core\Model\Entities\TranslateListener"})
 */
class Tag
{
	use TId;
	use TTranslateListener;

	/**
	 * @ORM\Column(type="string")
	 */
	public string $type;

	/**
	 * @var Collection<string, TagText>
	 * @ORM\OneToMany(targetEntity="TagText", mappedBy="tag", indexBy="lang", cascade={"all"})
	 */
	protected Collection $texts;

	/**
	 * @ORM\Column(type="string", nullable=true, length=255)
	 */
	public ?string $image = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $color = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $bgColor = null;

	/**
	 * @ORM\Column(type="smallint", options={"unsigned": true}, nullable=true)
	 */
	public ?int $ppcPriority = null;

	/**
	 * @ORM\Column(type="smallint", nullable=false, options={"default"=0})
	 */
	public int $hideProductTagName = 0;

	public function __construct()
	{
		$this->texts = new ArrayCollection;
	}

	public function setText(TagText $tagText): void
	{
		$this->texts->set($tagText->getLang(), $tagText);
	}

	public function setTexts(array $tagTexts): self
	{
		$this->texts = new ArrayCollection($tagTexts);

		return $this;
	}

	public function getText(?string $lang = null): ?TagText
	{
		return $this->texts->get($lang ?: $this->locale);
	}

	/**
	 * @return Collection<string, TagText>
	 */
	public function getTexts(): Collection { return $this->texts; }

}
