<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="eshop_catalog__tag_texts")
 * @ORM\Entity
 */
class TagText
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Tag", inversedBy="texts", cascade={"persist", "remove"})
	 * @ORM\JoinColumn(name="tag", referencedColumnName="id", onDelete="CASCADE")
	 */
	private Tag $tag;

	/**
	 * @ORM\Id
	 * @ORM\Column(type="string", length=2)
	 */
	private string $lang;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $name = null;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $description = null;

	public function __construct(Tag $tag, string $lang)
	{
		$this->tag  = $tag;
		$this->lang = $lang;
	}

	public function getLang(): string
	{
		return $this->lang;
	}

}
