<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Helpers;

class GoogleExportEnums
{
	public static array $list = [
		'color'                       => [
			'title' => 'eshopCatalog.googleType.color',
		],
		'gender'                      => [
			'title' => 'eshopCatalog.googleType.gender',
			'items' => [
				'male'   => 'eshopCatalog.googleTypeItems.male',
				'female' => 'eshopCatalog.googleTypeItems.female',
				'unisex' => 'eshopCatalog.googleTypeItems.unisex',
			],
		],
		'age_group'                   => [
			'title' => 'eshopCatalog.googleType.ageGroup',
			'items' => [
				'newborn' => 'eshopCatalog.googleTypeItems.newborn',
				'infant'  => 'eshopCatalog.googleTypeItems.infant',
				'toddler' => 'eshopCatalog.googleTypeItems.toddler',
				'kids'    => 'eshopCatalog.googleTypeItems.kids',
				'adult'   => 'eshopCatalog.googleTypeItems.adult',
			],
		],
		'material'                    => [
			'title' => 'eshopCatalog.googleType.material',
		],
		'pattern'                     => [
			'title' => 'eshopCatalog.googleType.pattern',
		],
		'size'                        => [
			'title' => 'eshopCatalog.googleType.size',
		],
		'size_type'                   => [
			'title' => 'eshopCatalog.googleType.sizeType',
		],
		'adult'                       => [
			'title' => 'eshopCatalog.googleType.adult',
			'items' => [
				'yes' => 'eshopCatalog.googleTypeItems.yes',
				'no'  => 'eshopCatalog.googleTypeItems.no',
			],
		],
		'multipack'                   => [
			'title' => 'eshopCatalog.googleType.multipack',
		],
		'is_bundle'                   => [
			'title' => 'eshopCatalog.googleType.isBundle',
			'items' => [
				'yes' => 'eshopCatalog.googleTypeItems.yes',
				'no'  => 'eshopCatalog.googleTypeItems.no',
			],
		],
		'certification'               => [
			'title' => 'eshopCatalog.googleType.certification',
		],
		'energy_efficiency_class'     => [
			'title' => 'eshopCatalog.googleType.energyEfficiencyClass',
			'items' => [
				'A+++' => 'eshopCatalog.googleTypeItems.A+++',
				'A++'  => 'eshopCatalog.googleTypeItems.A++',
				'A+'   => 'eshopCatalog.googleTypeItems.A+',
				'A'    => 'eshopCatalog.googleTypeItems.A',
				'B'    => 'eshopCatalog.googleTypeItems.B',
				'C'    => 'eshopCatalog.googleTypeItems.C',
				'D'    => 'eshopCatalog.googleTypeItems.D',
				'E'    => 'eshopCatalog.googleTypeItems.E',
				'F'    => 'eshopCatalog.googleTypeItems.F',
				'G'    => 'eshopCatalog.googleTypeItems.G',
			],
		],
		'min_energy_efficiency_class' => [
			'title' => 'eshopCatalog.googleType.minEnergyEfficiencyClass',
			'items' => [
				'A+++' => 'eshopCatalog.googleTypeItems.A+++',
				'A++'  => 'eshopCatalog.googleTypeItems.A++',
				'A+'   => 'eshopCatalog.googleTypeItems.A+',
				'A'    => 'eshopCatalog.googleTypeItems.A',
				'B'    => 'eshopCatalog.googleTypeItems.B',
				'C'    => 'eshopCatalog.googleTypeItems.C',
				'D'    => 'eshopCatalog.googleTypeItems.D',
				'E'    => 'eshopCatalog.googleTypeItems.E',
				'F'    => 'eshopCatalog.googleTypeItems.F',
				'G'    => 'eshopCatalog.googleTypeItems.G',
			],
		],
		'max_energy_efficiency_class' => [
			'title' => 'eshopCatalog.googleType.maxEnergyEfficiencyClass',
			'items' => [
				'A+++' => 'eshopCatalog.googleTypeItems.A+++',
				'A++'  => 'eshopCatalog.googleTypeItems.A++',
				'A+'   => 'eshopCatalog.googleTypeItems.A+',
				'A'    => 'eshopCatalog.googleTypeItems.A',
				'B'    => 'eshopCatalog.googleTypeItems.B',
				'C'    => 'eshopCatalog.googleTypeItems.C',
				'D'    => 'eshopCatalog.googleTypeItems.D',
				'E'    => 'eshopCatalog.googleTypeItems.E',
				'F'    => 'eshopCatalog.googleTypeItems.F',
				'G'    => 'eshopCatalog.googleTypeItems.G',
			],
		],
		'size_system'                 => [
			'title' => 'eshopCatalog.googleType.sizeSystem',
			'items' => [
				'US'  => 'eshopCatalog.googleTypeItems.US',
				'UK'  => 'eshopCatalog.googleTypeItems.UK',
				'EU'  => 'eshopCatalog.googleTypeItems.EU',
				'DE'  => 'eshopCatalog.googleTypeItems.DE',
				'FR'  => 'eshopCatalog.googleTypeItems.FR',
				'JP'  => 'eshopCatalog.googleTypeItems.JP',
				'CN'  => 'eshopCatalog.googleTypeItems.CN',
				'IT'  => 'eshopCatalog.googleTypeItems.IT',
				'BR'  => 'eshopCatalog.googleTypeItems.BR',
				'MEX' => 'eshopCatalog.googleTypeItems.MEX',
				'AU'  => 'eshopCatalog.googleTypeItems.AU',
			],
		],
		'product_highlight'           => [
			'title' => 'eshopCatalog.googleType.productHighlight',
		],
	];

	public static function getListForSelect(): array
	{
		$arr = [];

		foreach (self::$list as $k => $v) {
			$arr[$k] = $v['title'];
		}

		return $arr;
	}

	public static function getListItemsForSelect(): array
	{
		$arr = [];

		foreach (self::$list as $k => $v) {
			if (!isset($v['items'])) {
				continue;
			}

			foreach ($v['items'] as $vk => $vv) {
				$arr[$k][$k . '__' . $vk] = $vv;
			}
		}

		return $arr;
	}

}
