<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Listeners;

use Contributte\Translation\Translator;
use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use Nette\Caching\Cache;
use Nette\SmartObject;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class FeatureCategoryListener implements EventSubscriberInterface
{
	use SmartObject;

	protected CacheService $cacheService;
	protected Translator   $translator;

	public function __construct(
		CacheService $cacheService,
		Translator   $translator
	)
	{
		$this->cacheService = $cacheService;
		$this->translator   = $translator;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PreFlush
	 *
	 * @param object $entity
	 */
	public function onPreFlush($entity, Doctrine\ORM\Event\PreFlushEventArgs $args): void
	{
		$this->cacheService->filterCache->clean([
			Cache::TAGS => ['filters'],
		]);
	}

	/**
	 * @ORM\PostUpdate
	 * @ORM\PostRemove
	 *
	 * @param object $entity
	 */
	public function postHandler($entity, LifecycleEventArgs $event): void
	{
		$this->cacheService->filterCache->clean([
			Cache::TAGS => ['filters'],
		]);
	}

}
