<?php declare(strict_types = 1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20250922195640 extends AbstractMigration
{
	protected static array $safetyWarningImages = [];

	public function getDescription(): string
	{
		return '';
	}

	public function preUp(Schema $schema): void
	{
		parent::preUp($schema);

		foreach ($this->connection->fetchAllAssociative('SELECT id, safety_warning_image FROM eshop_catalog__category') as $row) {
			self::$safetyWarningImages[$row['id']] = $row['safety_warning_image'];
		}
	}

	public function up(Schema $schema): void
	{
		$this->addSql('ALTER TABLE eshop_catalog__category_texts ADD safety_warning_image VARCHAR(255) DEFAULT NULL');
	}

	public function postUp(Schema $schema): void
	{
		parent::postUp($schema);

		foreach ($this->connection->executeQuery("SELECT id, lang FROM eshop_catalog__category_texts")->iterateAssociative() as $row) {
			$img = self::$safetyWarningImages[$row['id']] ?? null;

			if ($img) {
				$this->connection->update('eshop_catalog__category_texts', [
					'safety_warning_image' => $img,
				], [
					'id'   => $row['id'],
					'lang' => $row['lang'],
				]);
			}
		}

		self::$safetyWarningImages = [];
	}

	public function down(Schema $schema): void
	{
		$this->addSql('ALTER TABLE eshop_catalog__category_texts DROP safety_warning_image');
	}
}
