import {slideUp, slideDown} from 'es6-slide-up-down';
const containers = document.querySelectorAll('[data-slide-container]');

containers.forEach(container => {
	const control = container.querySelector('[data-slide-control]');
	const content = container.querySelector('[data-slide-target]');

	if (control && content) {
		control.addEventListener('click', e => {
			e.stopPropagation();
			e.stopImmediatePropagation();
			if (content.classList.contains('active')) {
				content.classList.remove('active');
				control.classList.remove('active');
				slideUp(content, 500);
			}
			else {
				content.classList.add('active');
				control.classList.add('active');
				slideDown(content, 500);
			}
		})
	}
})