import {tns} from "tiny-slider";

document.addEventListener('DOMContentLoaded', () => {
	/**
	 * Inicializace defaultniho slideru
	 */
	document.querySelectorAll('.default-slider').forEach(el => {
		const sliderContainer = el.querySelector('.default-slider__slider');

		const slider     = tns({
			container           : sliderContainer,
			controls            : false,
			autoplay            : true,
			edgePadding         : 0,
			mouseDrag           : true,
			nav                 : false,
			autoplayButtonOutput: false,
			speed               : 1000,
			autoplayHoverPause  : true,
		});
		const rightArrow = el.querySelector('.default-slider__arrow--right');
		if (rightArrow) {
			rightArrow.addEventListener('click', () => {
				slider.goTo('next');
			})
		}

		const leftArrow = el.querySelector('.default-slider__arrow--left');
		if (leftArrow) {
			leftArrow.addEventListener('click', () => {
				slider.goTo('prev');
			});
		}
	});
})
