<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TSeo;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Nette\Utils\Strings;

/**
 * @ORM\Table(name="eshop_catalog__category_texts")
 * @ORM\Entity
 * @ORM\EntityListeners({"CategoryTextListener"})
 */
class CategoryTexts
{
	use TSeo;

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Category", inversedBy="categoryTexts", cascade={"persist"})
	 * @ORM\JoinColumn(name="id", referencedColumnName="id", onDelete="CASCADE")
	 * )
	 */
	public $id;

	/**
	 * @ORM\Id
	 * @ORM\Column(name="lang", type="string", length=2)
	 */
	private $lang;

	/**
	 * @ORM\Column(name="is_published", type="smallint", length=1, options={"default": 0})
	 */
	public int $isPublished = 0;

	/**
	 * @var string
	 * @ORM\Column(name="name", type="string", length=255)
	 */
	public $name;

	/**
	 * @var string
	 * @ORM\Column(name="name_h1", type="string", length=255, nullable=true)
	 */
	public $nameH1;

	/**
	 * @var string
	 * @ORM\Column(name="alias", type="string", length=255)
	 */
	public $alias;

	/**
	 * @var string
	 * @ORM\Column(name="description", type="text", nullable=true)
	 */
	public ?string $description = null;

	/**
	 * @var string
	 * @ORM\Column(name="short_description", type="text", nullable=true)
	 */
	public ?string $shortDescription = null;

	/**
	 * @var string
	 * @ORM\Column(name="empty_text", type="text", nullable=true)
	 */
	public ?string $emptyText = null;

	public function __construct($id, $lang)
	{
		$this->id   = $id;
		$this->name = '';
		$this->lang = $lang;
		$this->seo  = [];
	}

	public function setName(string $name): self
	{
		$this->name = $name;
		if (!$this->alias)
			$this->setAlias($name);

		return $this;
	}

	/** @return string */
	public function getName() { return $this->name; }

	public function setAlias(string $alias): self
	{
		$alias       = $alias != '' ? $alias : $this->name;
		$this->alias = Strings::webalize($alias);

		return $this;
	}

	public function getCategory() { return $this->id; }

	public function getLang()
	{
		return $this->lang;
	}

	public function setNameH1(string $nameH1): self
	{
		$this->nameH1 = $nameH1;

		return $this;
	}

	public function getNameH1(): string { return $this->nameH1 ?: $this->name; }
}

