<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Helpers;

use Core\Model\Helpers\Strings;

class DocumentsHelper
{
	public static function isSecured(string $file): bool { return Strings::startsWith($file, '/secured'); }

	public static function getFullPath(string $file): string { return (self::isSecured($file) ? APP_DIR : WWW_DIR) . $file; }
}
