<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Helpers;

class FilterHelper
{
	const        URL_KEY = 'productsFilter-filter';

	/**
	 * @param array $data
	 *
	 * @return array
	 */
	public static function filterUrlArrayToSimpleArray(array $data)
	{
		$result = [];

		if (isset($data[self::URL_KEY]))
			$data = $data[self::URL_KEY];

		foreach ($data['ff'] ?? [] as $k => $v)
			$result['features'][$k] = explode('|', $v);
		if ($data['fm'])
			$result['manufacturers'] = explode('|', $data['fm'][0]);

		return $result;
	}

	/**
	 * @param array $data
	 *
	 * @return array
	 */
	public static function simpleArrayToFilterUrlArray(array $data)
	{
		$result = [];

		foreach ($data['features'] as $k => $vals) {
			if (!$vals)
				continue;

			$result['ff'][$k] = implode('|', $vals);
		}

		if ($data['manufacturers'])
			$result['fm'][] = implode('|', $data['manufacturers']);

		return [self::URL_KEY => $result];
	}
}
