<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Helpers;

class ProductConditionEnum
{
	public const new         = 'new';
	public const refurbished = 'refurbished';
	public const used        = 'used';
	public const openBox     = 'openBox';

	public static function toSeznam(string $v): string
	{
		$arr = [
			self::new         => 'new',
			self::refurbished => 'refurbished',
			self::used        => 'used',
			self::openBox     => 'open_box',
		];

		return $arr[$v] ?? self::new;
	}

	public static function toGoogle(string $v): string
	{
		$arr = [
			self::new         => 'new',
			self::refurbished => 'refurbished',
			self::used        => 'used',
			self::openBox     => 'used',
		];

		return $arr[$v] ?? self::new;
	}
}
