document.addEventListener('autocompleteOnSelection', e => {
	if (e.detail.name !== 'packageProduct') {
		return;
	}

	const resp      = e;
	const input     = resp.target;
	const selection = resp.detail.selection;

	input.value = '';

	const table = document.querySelector('[data-target="' + input.id + '"]');

	if (!table) {
		return;
	}

	addRow(
		table,
		input.dataset.productLink,
		input.dataset.packageContainerName,
		selection.value.id,
		selection.value.code1,
		selection.value.name,
		1
	);
});

// document.addEventListener('DOMContentLoaded', e => {
// 	console.log('dom loaded');
// 	console.log(document.querySelectorAll('[data-package-container-name]'));
//
// 	document.querySelectorAll('[data-package-container-name]').forEach(input => {
// 		const table = document.querySelector('[data-target="' + input.id + '"]');
//
// 		if (!table) {
// 			return;
// 		}
//
// 		try {
// 			const jsonData = JSON.parse(table.dataset.defaults);
// 			for (let id in jsonData) {
// 				const item = jsonData[i];
//
// 				addRow(
// 					table,
// 					input.dataset.packageContainerName
// 				)
// 			}
// 		} catch (e) {
// 			console.log(e);
// 		}
// 	});
// });

const addRow = (table, productLink, containerName, id, code1, name, quantity) => {
	const tr = document.createElement('tr');
	tr.setAttribute('data-id', id);

	const tdCode     = document.createElement('td');
	tdCode.innerText = code1;

	const tdName     = document.createElement('td');
	tdName.innerHTML = '<a href="'+productLink.replace('__ID__', id)+'" target="_blank">'+name+'</a>';

	const tdQuantity     = document.createElement('td');
	tdQuantity.innerHTML = '<input name="' + containerName + '[' + id + '][quantity]" type="number" step="1" min="0" value="' + quantity + '">';

	const tdAction     = document.createElement('td');
	tdAction.innerHTML = '<a href="javascript:;" class="btn btn-xs btn-danger" data-remove-table-tr><i class="fas fa-times"></i></a>';

	tr.appendChild(tdCode);
	tr.appendChild(tdName);
	tr.appendChild(tdQuantity);
	tr.appendChild(tdAction);

	table.querySelector('tbody').appendChild(tr);

}
