<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\Products;

use Core\Model\Lang\DefaultLang;
use Core\Model\UI\Form\BaseContainer;
use EshopCatalog\AdminModule\Model\Tags;
use Nette\Utils\ArrayHash;

class TagsContainer
{
	public function __construct(protected Tags $tagServices, protected DefaultLang $defaultLang)
	{
	}

	public function getContainer(): BaseContainer
	{
		$container = new BaseContainer;

		$tags = $this->tagServices->getEr()->createQueryBuilder('t')
			->select('t.id, t.type, tt.name')
			->leftJoin('t.texts', 'tt', 'WITH', 'tt.lang = :lang')
			->setParameter('lang', $this->defaultLang->locale)
			->getQuery()->getResult();

		foreach ($tags as $t) {
			$container2 = new BaseContainer;
			$container2->addBool('active', $t['name']);
			$container2->addDateTimePicker('dateFrom', 'eshopCatalog.tagContainer.dateFrom')
				->setDescription('eshopCatalog.tagContainer.dateDesc');
			$container2->addDateTimePicker('dateTo', 'eshopCatalog.tagContainer.dateTo')
				->setDescription('eshopCatalog.tagContainer.dateDesc');
			$container2->addHidden('id', (string) $t['id']);

			$container->addComponent($container2, $t['type']);
		}

		$container->addCustomData('template', __DIR__ . '/TagsContainer.latte');

		return $container;
	}

	public function getFormData(array|ArrayHash $values): array
	{
		return (array) $values;
	}

	public function setDefaults(BaseContainer $container, array|ArrayHash $values): void
	{
		$container->setDefaults($values);
	}

}
