<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\Suppliers;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopCatalog\AdminModule\Model\Suppliers;
use EshopCatalog\Model\Entities\Supplier;
use EshopCatalog\Model\Entities\SupplierTexts;
use Exception;
use Nette\Utils\ArrayHash;

class SupplierForm extends BaseControl
{
	public ?Supplier     $supplier = null;
	public SupplierTexts $supplierTexts;

	public function __construct(protected Suppliers $supplierServices)
	{
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();

		$form->addText('name', 'eshopCatalog.supplierForm.name')->setRequired()->setMaxLength(255);
		$form->addBool('isPublished', 'eshopCatalog.supplierForm.isPublished')->setDefaultValue(0);
		$form->addText('website', 'eshopCatalog.manufacturerForm.website')
			->setNullable()
			->setMaxLength(255);
		$form->addEditor('desc', 'eshopCatalog.supplierForm.desc')->setHeight(300);

		$form->addSaveCancelControl();

		//editace
		if ($this->supplier) {
			$form->setDefaults([
				'isPublished' => $this->supplier->isPublished,
				'name'        => $this->supplier->name,
				'desc'        => $this->supplierTexts->description,
				'website'     => $this->supplier->website,
			]);
		}

		$form->onSuccess[] = $this->formSuccess(...);

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): void
	{
		try {
			$supplier = $this->supplier ?? new Supplier($values->name);

			$supplier->name        = $values->name;
			$supplier->isPublished = $values->isPublished;
			$supplier->website     = $values->website ?: null;

			if (!$supplier->getSupplierText('cs')) {
				$supplier->addSupplierText('cs');
			}
			$supplier->getSupplierText('cs')->description = $values->desc;

			$this->em->persist($supplier);
			$this->em->flush();
			$form->addCustomData('supplierId', $supplier->getId());
			$this->presenter->flashMessageSuccess('eshopCatalog.supplierForm.supplierSaved');
		} catch (Exception $e) {
			$form->addError($e->getMessage());
		}
	}

	public function setSupplier(int $id): void
	{
		$this->supplier = $this->em->getRepository(Supplier::class)->find($id);

		/** @var SupplierTexts|null $text */
		$text                = $this->em->getRepository(SupplierTexts::class)->findOneBy(['id' => $id, 'lang' => 'cs']);
		$this->supplierTexts = $text;

		if (!$this->supplier) {
			$this->presenter->error();
		}
	}

}
