<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model\Helpers;

use Core\AdminModule\Model\Sites;
use Core\Model\Countries;
use EshopCatalog\AdminModule\Model\AvailabilityService;
use EshopCatalog\AdminModule\Model\ProductPriceLevels;
use EshopCatalog\Model\Config;
use EshopOrders\AdminModule\Model\GroupsCustomers;
use EshopOrders\Model\Entities\GroupCustomers;
use Nette\DI\Attributes\Inject;

class ProductFormHelper
{
	#[Inject]
	public GroupsCustomers $groupsCustomersService;

	#[Inject]
	public ProductPriceLevels $productPriceLevelsService;

	#[Inject]
	public AvailabilityService $availabilityService;

	#[Inject]
	public Config $config;

	#[Inject]
	public Sites $sitesService;

	#[Inject]
	public Countries $countries;

	/** @var GroupCustomers[]|null */
	protected ?array $groupCustomers = null;

	/**
	 * @return GroupCustomers[]
	 */
	public function getGroupCustomers(): array
	{
		if ($this->groupCustomers === null) {
			$this->groupCustomers = $this->groupsCustomersService->getEr()->createQueryBuilder('g', 'g.id')->getQuery()
				->getResult();
		}

		return $this->groupCustomers;
	}

}
