<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\Model\Entities\ProductVideo;

/**
 * @method ProductVideo|null get(int $id)
 */
class ProductVideos extends BaseEntityService
{
	protected $entityClass = ProductVideo::class;

	public function __construct(protected CacheService $cacheService)
	{
	}

	/**
	 * @return ProductVideo[]
	 */
	public function getByProduct(int $productId): array
	{
		$qb = $this->getEr()->createQueryBuilder('pv');

		return $qb->join('pv.product', 'p')
			->where('p.id = :pid')
			->setParameter('pid', $productId)
			->getQuery()->getResult();
	}

	/**
	 * @inheritDoc
	 */
	public function remove($id): bool
	{
		$video = $this->get((int) $id);

		if ($video) {
			$productId = $video->product->getId();
			$result    = parent::remove($id);
			$this->cacheService->removeVideos([$productId]);

			return $result;
		}

		return false;
	}

}
