<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPosition;
use EshopCatalog\Model\Entities\ProductAssignCustomer;

/**
 * @method ProductAssignCustomer|null getReference($id)
 * @method ProductAssignCustomer[] getAll()
 * @method ProductAssignCustomer|null get($id)
 */
class ProductsAssignedToCustomers extends BaseEntityService
{
	use TPosition;

	protected $entityClass = ProductAssignCustomer::class;

	/**
	 * @inheritDoc
	 */
	public function remove($id): bool
	{
		if ($entity = $this->get($id)) {
			$product                 = $entity->getProduct();
			$product->disableListing = 0;
			$this->em->persist($product);

			$this->em->remove($entity);
			$this->em->flush();

			return true;
		}

		return false;
	}

}
