<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPublish;
use EshopCatalog\Model\Entities\Supplier;

/**
 * @method Supplier|null getReference($id)
 * @method Supplier[] getAll()
 * @method Supplier|null get($id)
 */
class Suppliers extends BaseEntityService
{
	use TPublish;

	protected $entityClass = Supplier::class;

	/**
	 * @return array<int, string>
	 */
	public function getOptionsForSelect(): array
	{
		$result = [];

		foreach ($this->getEr()->createQueryBuilder('s')->select('s.id, s.name')
			         ->orderBy('s.name')->getQuery()->getArrayResult() as $row) {
			$result[(int) $row['id']] = (string) $row['name'];
		}

		return $result;
	}

}
