<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model;

use Core\Model\Exceptions\EntityHasRelations;
use Core\Model\Helpers\BaseEntityService;
use EshopCatalog\Model\Entities\Product;
use EshopCatalog\Model\Entities\VatRate;

/**
 * @method VatRate|null getReference($id)
 * @method VatRate[] getAll()
 * @method VatRate|null get($id)
 */
class VatRates extends BaseEntityService
{
	protected       $entityClass = VatRate::class;
	protected array $cList       = [];

	/**
	 * @inheritDoc
	 */
	public function remove($id): bool
	{
		$inProducts = $this->em->getRepository(Product::class)->findBy(['vatRate' => $id, 'isDeleted' => 0]);

		if (count($inProducts) > 0) {
			throw new EntityHasRelations('eshopCatalog.vatRate.removeFailedHasProducts');
		}

		return parent::remove($id);
	}

	/**
	 * @return VatRate[]
	 */
	public function getListByRate(): array
	{
		if (!empty($this->cList)) {
			return $this->cList;
		}

		foreach ($this->getAll() as $v) {
			$this->cList[$v->rate] = $v;
		}

		return $this->cList;
	}

	/**
	 * @return array<int, string>
	 */
	public function getOptionsForSelect(): array
	{
		$arr = [];

		foreach ($this->getEr()->createQueryBuilder('vr')->select('vr.id, vr.name')
			         ->getQuery()->getScalarResult() as $row) {
			$arr[(int) $row['id']] = (string) $row['name'];
		}

		return $arr;
	}

	public function getListForPohoda(): array
	{
		$arr = [];

		foreach ($this->getEr()->createQueryBuilder('vr')->select('vr.rate', 'vr.pohodaRate')
			         ->getQuery()->getArrayResult() as $row) {
			if (!$row['pohodaRate']) {
				continue;
			}

			$arr['byRate'][$row['rate']] = $row['pohodaRate'];

			$sumKey                       = $row['pohodaRate'] === 'third' ? '3' : ucfirst((string) $row['pohodaRate']);
			$arr['summary'][$row['rate']] = 'price' . $sumKey;
		}

		return $arr;
	}

}
