<?php declare(strict_types = 1);

namespace EshopCatalog\DI;

use Core\DI\CompilerExtension;
use Nette;

class EshopCatalogExtension extends CompilerExtension
{

	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['EshopCatalog' => 'EshopCatalog\*Module\Presenters\*Presenter']);
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class)
	{
		parent::afterCompile($class);
		$init    = $class->getMethod('initialize');
		$builder = $this->getContainerBuilder();

		$init->addBody('EshopCatalog\Model\Config::setParams($this->parameters[\'eshopCatalog\']);');
		$init->addBody(
			'$this->getService(\'eshopCatalog.front.categories\')->linkGenerator = $this->getService(\'application.linkGenerator\');',
		);
		$init->addBody(
			'$this->getService(\'eshopCatalog.front.products\')->linkGenerator = $this->getService(\'application.linkGenerator\');',
		);
		$init->addBody(
			'$this->getService(\'eshopCatalog.front.productsFacade\')->linkGenerator = $this->getService(\'application.linkGenerator\');',
		);
		$init->addBody(
			'$this->getService(\'eshopCatalog.front.featureProducts\')->linkGenerator = $this->getService(\'application.linkGenerator\');',
		);
		$init->addBody(
			'$this->getService(\'eshopCatalog.front.featureProducts\')->navigations = $this->getService(\'navigations.navigations\');',
		);
	}
}
