<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Dao;

use EshopCatalog\Model\Helpers\DocumentsHelper;

class Document
{
	public function __construct(
		protected int     $id,
		protected string  $name,
		protected string  $file,
		protected ?string $lang = null,
	)
	{
	}

	public function isSecured(): bool { return DocumentsHelper::isSecured($this->file); }

	public function getFilePath(): string { return $this->isSecured() ? '#' : $this->file; }

	public function getId(): int { return $this->id; }

	public function getName(): string { return $this->name; }

	public function getLang(): ?string { return $this->lang; }

}
