<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Dao;

class RelatedGroup
{
	/** @var Product[] */
	protected array $products = [];

	public function __construct(protected int $id, protected string $name)
	{
	}

	public function getName(): string { return $this->name; }

	public function getId(): int { return $this->id; }

	public function addProduct(Product $product): self
	{
		$this->products[] = $product;

		return $this;
	}

	/**
	 * @return Product[]
	 */
	public function getProducts(): array { return $this->products; }

}
