<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model;

use Contributte\Translation\Translator;
use Core\Model\Entities\EntityManagerDecorator;
use EshopCatalog\FrontModule\Model\Dao;
use EshopCatalog\Model\Entities\ProductVideo;
use Nette\Caching\Cache;

class ProductVideos
{
	final public const CACHE_NAMESPACE = 'eshopCatalogProductsVideos';

	/** @var Dao\Video[][] */
	protected array $cVideos = [];

	public function __construct(
		protected EntityManagerDecorator $em,
		protected Translator             $translator,
		protected CacheService           $cacheService,
	)
	{
	}

	/**
	 * @return Dao\Video[][]
	 */
	public function getVideos(array $ids): array
	{
		$whereIds = [];
		/** @var Dao\Video[][] $result */
		$result = [];
		$keys   = [];
		$locale = $this->translator->getLocale();

		foreach ($ids as $id) {
			if (isset($this->cVideos[$id])) {
				$result[$id] = $this->cVideos[$id];
			} else {
				$keys[] = 'videos/' . $id;
			}
		}

		foreach ($this->cacheService->videosCache->bulkLoad($keys) as $key => $videos) {
			$id = explode('/', $key)[1];

			if ($videos !== null) {
				$this->cVideos[$id] = $videos;
				$result[$id]        = $videos;
			} else {
				$whereIds[] = $id;
			}
		}

		if (!empty($whereIds)) {
			$qb = $this->em->getRepository(ProductVideo::class)->createQueryBuilder('pv')
				->select('IDENTITY(pv.product) as product, pv.title, pv.url, pv.lang, pv.thumbnail')
				->where('pv.product IN (:ids)')
				->setParameters([
					'ids' => $whereIds,
				]);

			foreach ($qb->getQuery()->getArrayResult() as $row) {
				$this->cVideos[$row['product']][] = $this->fillDao($row);
			}

			foreach ($whereIds as $id) {
				if (!isset($this->cVideos[$id])) {
					$this->cVideos[$id] = [];
				} else {
					$result[$id] = $this->cVideos[$id];
				}

				$this->cacheService->videosCache->save('videos/' . $id, $this->cVideos[$id], [
					Cache::Expire => '14 days',
				]);
			}
		}

		foreach ($result as $id => $documents) {
			foreach ($documents as $k => $v) {
				if ($v->getLang() !== null && $v->getLang() !== $locale) {
					unset($result[$id][$k]);
				}
			}
		}

		return $result;
	}

	protected function fillDao(array $data): Dao\Video
	{
		return new Dao\Video($data['title'], $data['url'], $data['lang'], $data['thumbnail']);
	}

}
