<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Presenters;

use EshopCatalog\FrontModule\Model\OrderDocuments;
use Nette\Application\BadRequestException;
use Nette\Application\Responses\FileResponse;
use Nette\DI\Attributes\Inject;

class DocumentsPresenter extends BasePresenter
{
	#[Inject]
	public OrderDocuments $orderDocuments;

	public function actionOpen(int $id, int $order, int $product): void
	{
		$document = $this->orderDocuments->find($id, $order, $product);

		if (!$document) {
			throw new BadRequestException;
		}

		$this->sendResponse(new FileResponse($document->getFullPath(), basename($document->file), null, true));
	}

}
