<?php declare(strict_types = 1);

namespace EshopCatalog\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20191220142144 extends AbstractMigration
{
	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf(
			$this->connection->getDatabasePlatform()
				->getName() !== 'mysql',
			'Migration can only be executed safely on \'mysql\'.',
		);

		$this->addSql(
			'CREATE TABLE eshop_catalog__product_in_site (product_id INT NOT NULL, site VARCHAR(255) NOT NULL, is_active SMALLINT DEFAULT 0 NOT NULL, INDEX IDX_50DB9704584665A (product_id), INDEX IDX_50DB970694309E4 (site), PRIMARY KEY(product_id, site)) DEFAULT CHARACTER SET UTF8 COLLATE `UTF8_unicode_ci` ENGINE = InnoDB',
		);
		$this->addSql(
			'ALTER TABLE eshop_catalog__product_in_site ADD CONSTRAINT FK_50DB9704584665A FOREIGN KEY (product_id) REFERENCES eshop_catalog__product (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE eshop_catalog__product_in_site ADD CONSTRAINT FK_50DB970694309E4 FOREIGN KEY (site) REFERENCES core__site (ident) ON DELETE CASCADE',
		);

		$this->addSql('ALTER TABLE eshop_catalog__product_in_site ADD category_id INT DEFAULT NULL');
		$this->addSql(
			'ALTER TABLE eshop_catalog__product_in_site ADD CONSTRAINT FK_50DB97012469DE2 FOREIGN KEY (category_id) REFERENCES eshop_catalog__category (id) ON DELETE SET NULL',
		);
		$this->addSql('CREATE INDEX IDX_50DB97012469DE2 ON eshop_catalog__product_in_site (category_id)');
	}

	public function postUp(Schema $schema): void
	{
		parent::postUp($schema); // TODO: Change the autogenerated stub

		$sites = $this->connection->fetchAllAssociative("SELECT ident FROM core__site LIMIT 1");
		if ($sites[0]) {
			$site = $sites[0]['ident'];

			foreach ($this->connection->fetchAllAssociative("SELECT id, id_category_default FROM eshop_catalog__product WHERE id_category_default IS NOT NULL") as $row) {
				$this->connection->insert('eshop_catalog__product_in_site', [
					'product_id'  => $row['id'],
					'site'        => $site,
					'is_active'   => 1,
					'category_id' => $row['id_category_default'],
				]);
			}

			$rootCat = $this->connection->fetchAssociative("SELECT id FROM eshop_catalog__category WHERE parent_id IS NULL");
			if ($rootCat) {
				$this->connection->executeQuery(
					"INSERT IGNORE INTO eshop_catalog__category_texts (`name`, `alias`, `lang`, `id`) VALUES (?, ?, ?, ?)",
					[$site, $site, 'cs', $rootCat['id']]
				);
			}
		}
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf(
			$this->connection->getDatabasePlatform()
				->getName() !== 'mysql',
			'Migration can only be executed safely on \'mysql\'.',
		);

		$this->addSql('ALTER TABLE eshop_catalog__product_in_site DROP FOREIGN KEY FK_50DB97012469DE2');
		$this->addSql('DROP INDEX IDX_50DB97012469DE2 ON eshop_catalog__product_in_site');
		$this->addSql('ALTER TABLE eshop_catalog__product_in_site DROP category_id');

		$this->addSql('DROP TABLE eshop_catalog__product_in_site');
	}
}
