<?php

declare(strict_types = 1);

namespace EshopCatalog\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20200128084429 extends AbstractMigration
{
	public function getDescription(): string
	{
		return '';
	}

	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf(
			$this->connection->getDatabasePlatform()
				->getName() !== 'mysql',
			'Migration can only be executed safely on \'mysql\'.',
		);

		$this->addSql('ALTER TABLE eshop_catalog__product_variant_combination DROP FOREIGN KEY FK_A5E7EE85C9C46795');
		$this->addSql('ALTER TABLE eshop_catalog__product_variant_supplier DROP FOREIGN KEY FK_F7508515C9C46795');
		$this->addSql('ALTER TABLE eshop_catalog__product_variant_combination DROP FOREIGN KEY FK_A5E7EE852FDE16DD');
		$this->addSql('ALTER TABLE eshop_catalog__variant_text DROP FOREIGN KEY FK_E5F13513B69A9AF');
		$this->addSql('ALTER TABLE eshop_catalog__variant_value DROP FOREIGN KEY FK_42EBAF13B69A9AF');
		$this->addSql('ALTER TABLE eshop_catalog__product_variant_combination DROP FOREIGN KEY FK_A5E7EE8523D5160C');
		$this->addSql('ALTER TABLE eshop_catalog__variant_value_text DROP FOREIGN KEY FK_378AAE2166F0FA2A');
		$this->addSql('DROP TABLE eshop_catalog__product_variant');
		$this->addSql('DROP TABLE eshop_catalog__product_variant_combination');
		$this->addSql('DROP TABLE eshop_catalog__product_variant_supplier');
		$this->addSql('DROP TABLE eshop_catalog__variant');
		$this->addSql('DROP TABLE eshop_catalog__variant_text');
		$this->addSql('DROP TABLE eshop_catalog__variant_value');
		$this->addSql('DROP TABLE eshop_catalog__variant_value_text');
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf(
			$this->connection->getDatabasePlatform()
				->getName() !== 'mysql',
			'Migration can only be executed safely on \'mysql\'.',
		);

		$this->addSql(
			'CREATE TABLE eshop_catalog__product_variant (id INT AUTO_INCREMENT NOT NULL, id_product INT DEFAULT NULL, is_default SMALLINT NOT NULL, quantity INT NOT NULL, ean VARCHAR(20) CHARACTER SET utf8 DEFAULT NULL COLLATE `utf8_unicode_ci`, code1 VARCHAR(60) CHARACTER SET utf8 DEFAULT NULL COLLATE `utf8_unicode_ci`, code2 VARCHAR(60) CHARACTER SET utf8 DEFAULT NULL COLLATE `utf8_unicode_ci`, unit_price_impact NUMERIC(10, 2) DEFAULT NULL, INDEX IDX_B7B6305DDD7ADDD (id_product), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB COMMENT = \'\' ',
		);
		$this->addSql(
			'CREATE TABLE eshop_catalog__product_variant_combination (id_product_variant INT NOT NULL, id_variant_value INT NOT NULL, id_variant INT DEFAULT NULL, INDEX IDX_A5E7EE8523D5160C (id_variant_value), INDEX IDX_A5E7EE852FDE16DD (id_variant), INDEX IDX_A5E7EE85C9C46795 (id_product_variant), PRIMARY KEY(id_product_variant, id_variant_value)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB COMMENT = \'\' ',
		);
		$this->addSql(
			'CREATE TABLE eshop_catalog__product_variant_supplier (id_supplier INT NOT NULL, id_product_variant INT NOT NULL, quantity INT NOT NULL, INDEX IDX_F7508515C9C46795 (id_product_variant), INDEX IDX_F7508515CBF180EB (id_supplier), PRIMARY KEY(id_supplier, id_product_variant)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB COMMENT = \'\' ',
		);
		$this->addSql(
			'CREATE TABLE eshop_catalog__variant (id INT AUTO_INCREMENT NOT NULL, use_filter SMALLINT NOT NULL, type SMALLINT NOT NULL, position INT NOT NULL, is_published SMALLINT NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB COMMENT = \'\' ',
		);
		$this->addSql(
			'CREATE TABLE eshop_catalog__variant_text (lang VARCHAR(2) CHARACTER SET utf8 NOT NULL COLLATE `utf8_unicode_ci`, variant_id INT NOT NULL, name VARCHAR(255) CHARACTER SET utf8 NOT NULL COLLATE `utf8_unicode_ci`, INDEX IDX_E5F13513B69A9AF (variant_id), INDEX lang_id_name (lang, variant_id, name), PRIMARY KEY(variant_id, lang)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB COMMENT = \'\' ',
		);
		$this->addSql(
			'CREATE TABLE eshop_catalog__variant_value (id INT AUTO_INCREMENT NOT NULL, variant_id INT DEFAULT NULL, position INT NOT NULL, is_published SMALLINT NOT NULL, INDEX IDX_42EBAF13B69A9AF (variant_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB COMMENT = \'\' ',
		);
		$this->addSql(
			'CREATE TABLE eshop_catalog__variant_value_text (lang VARCHAR(2) CHARACTER SET utf8 NOT NULL COLLATE `utf8_unicode_ci`, variant_value_id INT NOT NULL, name VARCHAR(255) CHARACTER SET utf8 NOT NULL COLLATE `utf8_unicode_ci`, INDEX IDX_378AAE2166F0FA2A (variant_value_id), INDEX lang_id_name (lang, variant_value_id, name), PRIMARY KEY(variant_value_id, lang)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB COMMENT = \'\' ',
		);
		$this->addSql(
			'ALTER TABLE eshop_catalog__product_variant ADD CONSTRAINT FK_B7B6305DDD7ADDD FOREIGN KEY (id_product) REFERENCES eshop_catalog__product (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE eshop_catalog__product_variant_combination ADD CONSTRAINT FK_A5E7EE8523D5160C FOREIGN KEY (id_variant_value) REFERENCES eshop_catalog__variant_value (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE eshop_catalog__product_variant_combination ADD CONSTRAINT FK_A5E7EE852FDE16DD FOREIGN KEY (id_variant) REFERENCES eshop_catalog__variant (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE eshop_catalog__product_variant_combination ADD CONSTRAINT FK_A5E7EE85C9C46795 FOREIGN KEY (id_product_variant) REFERENCES eshop_catalog__product_variant (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE eshop_catalog__product_variant_supplier ADD CONSTRAINT FK_F7508515C9C46795 FOREIGN KEY (id_product_variant) REFERENCES eshop_catalog__product_variant (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE eshop_catalog__product_variant_supplier ADD CONSTRAINT FK_F7508515CBF180EB FOREIGN KEY (id_supplier) REFERENCES eshop_catalog__supplier (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE eshop_catalog__variant_text ADD CONSTRAINT FK_E5F13513B69A9AF FOREIGN KEY (variant_id) REFERENCES eshop_catalog__variant (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE eshop_catalog__variant_value ADD CONSTRAINT FK_42EBAF13B69A9AF FOREIGN KEY (variant_id) REFERENCES eshop_catalog__variant (id)',
		);
		$this->addSql(
			'ALTER TABLE eshop_catalog__variant_value_text ADD CONSTRAINT FK_378AAE2166F0FA2A FOREIGN KEY (variant_value_id) REFERENCES eshop_catalog__variant_value (id) ON DELETE CASCADE',
		);
	}
}
