<?php declare(strict_types = 1);

namespace EshopCatalog\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20210611081906 extends AbstractMigration
{
	public function getDescription(): string
	{
		return '';
	}

	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf(
			$this->connection->getDatabasePlatform()
				->getName() !== 'mysql',
			'Migration can only be executed safely on \'mysql\'.',
		);

		$this->addSql(
			'CREATE TABLE eshop_catalog__product_price (product INT NOT NULL, country VARCHAR(255) NOT NULL, vat_rate INT DEFAULT NULL, currency_code VARCHAR(255) NOT NULL, price NUMERIC(10, 2) DEFAULT NULL, retail_price NUMERIC(10, 2) DEFAULT NULL, INDEX IDX_F247241DD34A04AD (product), INDEX IDX_F247241D5373C966 (country), INDEX IDX_F247241DF684F7C7 (vat_rate), PRIMARY KEY(product, country)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB',
		);
		$this->addSql(
			'ALTER TABLE eshop_catalog__product_price ADD CONSTRAINT FK_F247241DD34A04AD FOREIGN KEY (product) REFERENCES eshop_catalog__product (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE eshop_catalog__product_price ADD CONSTRAINT FK_F247241D5373C966 FOREIGN KEY (country) REFERENCES core__country (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE eshop_catalog__product_price ADD CONSTRAINT FK_F247241DF684F7C7 FOREIGN KEY (vat_rate) REFERENCES eshop_catalog__vat_rate (id) ON DELETE SET NULL',
		);
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf(
			$this->connection->getDatabasePlatform()
				->getName() !== 'mysql',
			'Migration can only be executed safely on \'mysql\'.',
		);

		$this->addSql('DROP TABLE eshop_catalog__product_price');
	}
}
