<?php declare(strict_types = 1);

namespace EshopCatalog\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20230217123707 extends AbstractMigration
{
	public function getDescription(): string
	{
		return '';
	}

	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf(
			$this->connection->getDatabasePlatform()
				->getName() !== 'mysql',
			'Migration can only be executed safely on \'mysql\'.',
		);

		$this->addSql(
			'ALTER TABLE eshop_catalog__product CHANGE is_published is_published SMALLINT DEFAULT 0 NOT NULL',
		);
		$this->addSql('ALTER TABLE eshop_catalog__product_texts ADD is_published SMALLINT DEFAULT 0 NOT NULL');
	}

	public function postUp(Schema $schema): void
	{
		foreach ($this->connection->fetchAllAssociative(
			"SELECT id, is_published FROM eshop_catalog__product",
		) as $row) {
			$this->connection->executeQuery("UPDATE eshop_catalog__product_texts SET is_published = ? WHERE id = ?", [
				(int) $row['is_published'], (int) $row['id'],
			]);
		}

		parent::postUp($schema);
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf(
			$this->connection->getDatabasePlatform()
				->getName() !== 'mysql',
			'Migration can only be executed safely on \'mysql\'.',
		);

		$this->addSql('ALTER TABLE eshop_catalog__product_texts DROP is_published');
	}
}
