<?php declare(strict_types = 1);

namespace EshopCatalog\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20230309112931 extends AbstractMigration
{
	public function getDescription(): string
	{
		return '';
	}

	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf(
			$this->connection->getDatabasePlatform()
				->getName() !== 'mysql',
			'Migration can only be executed safely on \'mysql\'.',
		);

		$this->addSql(
			'CREATE TABLE eshop_catalog__package (id INT UNSIGNED AUTO_INCREMENT NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB',
		);
		$this->addSql(
			'CREATE TABLE eshop_catalog__package_item (id INT UNSIGNED AUTO_INCREMENT NOT NULL, package_id INT UNSIGNED NOT NULL, product_id INT NOT NULL, quantity INT UNSIGNED DEFAULT 1 NOT NULL, INDEX IDX_7E7A62D5F44CABFF (package_id), INDEX IDX_7E7A62D54584665A (product_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB',
		);
		$this->addSql(
			'ALTER TABLE eshop_catalog__package_item ADD CONSTRAINT FK_7E7A62D5F44CABFF FOREIGN KEY (package_id) REFERENCES eshop_catalog__package (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE eshop_catalog__package_item ADD CONSTRAINT FK_7E7A62D54584665A FOREIGN KEY (product_id) REFERENCES eshop_catalog__product (id) ON DELETE CASCADE',
		);
		$this->addSql('ALTER TABLE eshop_catalog__product ADD package_id INT UNSIGNED DEFAULT NULL');
		$this->addSql(
			'ALTER TABLE eshop_catalog__product ADD CONSTRAINT FK_54FD0ED0F44CABFF FOREIGN KEY (package_id) REFERENCES eshop_catalog__package (id) ON DELETE SET NULL',
		);
		$this->addSql('CREATE INDEX IDX_54FD0ED0F44CABFF ON eshop_catalog__product (package_id)');
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf(
			$this->connection->getDatabasePlatform()
				->getName() !== 'mysql',
			'Migration can only be executed safely on \'mysql\'.',
		);

		$this->addSql('ALTER TABLE eshop_catalog__package_item DROP FOREIGN KEY FK_7E7A62D5F44CABFF');
		$this->addSql('ALTER TABLE eshop_catalog__product DROP FOREIGN KEY FK_54FD0ED0F44CABFF');
		$this->addSql('DROP TABLE eshop_catalog__package');
		$this->addSql('DROP TABLE eshop_catalog__package_item');
		$this->addSql('DROP INDEX IDX_54FD0ED0F44CABFF ON eshop_catalog__product');
		$this->addSql('ALTER TABLE eshop_catalog__product DROP package_id');
	}
}
