<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\PostRemoveEventArgs;
use Doctrine\ORM\Event\PostUpdateEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\FrontModule\Model\Categories;
use Nette\Caching\Cache;
use Nette\SmartObject;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class CategoryListener implements EventSubscriberInterface
{
	use SmartObject;

	public function __construct(
		protected CacheService $cacheService,
	)
	{
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	#[ORM\PostUpdate]
	public function postUpdateHandler(Category $category, PostUpdateEventArgs $event): void
	{
		$this->cacheService->clean('category', [Cache::Tags => ['categories']]);
	}

	#[ORM\PostRemove]
	public function postRemoveHandler(Category $category, PostRemoveEventArgs $event): void
	{
		$tags2 = [
			Categories::CACHE_NAMESPACE,
		];

		if ($category->getParent()) {
			$tags2[] = 'category/' . $category->getParent()->getId();
		}

		$this->cacheService->clean('category', [Cache::Tags => $tags2]);
	}

}
