<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'eshop_catalog__category_product')]
#[ORM\Entity]
#[ORM\EntityListeners([CategoryProductListener::class])]
class CategoryProduct
{
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Product::class, cascade: ['persist'], inversedBy: 'categoryProducts')]
	#[ORM\JoinColumn(name: 'id_product', referencedColumnName: 'id', onDelete: 'cascade')]
	private Product $product;

	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Category::class, cascade: ['persist'], inversedBy: 'categoryProducts')]
	#[ORM\JoinColumn(name: 'id_category', referencedColumnName: 'id', onDelete: 'cascade')]
	private Category $category;

	public function __construct(Product $product, Category $category)
	{
		$this->product  = $product;
		$this->category = $category;
	}

	public function getIdProduct(): ?int
	{
		return $this->product->getId();
	}

	public function getIdCategory(): ?int
	{
		return $this->category->getId();
	}

	public function getCategory(): Category { return $this->category; }

}
