<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\PreFlushEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\Model\Helpers\VariantsHelper;
use Exception;
use Nette\SmartObject;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class CategoryProductListener implements EventSubscriberInterface
{
	use SmartObject;

	protected static array $created = [];

	public function __construct(
		protected CacheService   $cacheService,
		protected VariantsHelper $variantsHelper,
	)
	{
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	#[ORM\PreFlush]
	public function onPreFlush(CategoryProduct $categoryProduct, PreFlushEventArgs $args): void
	{
		$em = $args->getObjectManager();
		foreach ($em->getUnitOfWork()->getScheduledEntityInsertions() as $entity) {
			if ($entity instanceof CategoryProduct === false || $entity->getIdProduct() === null) {
				continue;
			}

			$key = $entity->getIdProduct() . '-' . $entity->getIdCategory();
			if (isset(self::$created[$key])) {
				continue;
			}
			self::$created[$key] = true;

			foreach ($this->variantsHelper->getVariantsOfProduct($entity->getIdProduct()) as $prodId) {
				try {
					$em->getConnection()->insert('eshop_catalog__category_product', [
						'id_product'  => $prodId,
						'id_category' => $entity->getIdCategory(),
					]);
				} catch (Exception $e) {
				}
			}
		}
	}

}
