<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Contributte\Translation\Translator;
use Doctrine;
use Doctrine\ORM\Event\PostUpdateEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\Model\Config;
use Exception;
use Navigations\Model\Navigations;
use Nette\Caching\Cache;
use Nette\SmartObject;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Tracy\Debugger;

class CategoryTextListener implements EventSubscriberInterface
{
	use SmartObject;

	protected static array $cleared = [];

	public function __construct(
		protected Translator   $translator,
		protected CacheService $cacheService,
	)
	{
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	#[ORM\PostUpdate]
	public function postUpdateHandler(CategoryTexts $categoryText, PostUpdateEventArgs $event): void
	{
		if (!self::$cleared[$categoryText->getCategory()->getId()]) {
			$em        = $event->getObjectManager();
			$changeSet = $em->getUnitOfWork()->getEntityChangeSet($categoryText);

			if (isset($changeSet['alias'])) {
				$this->cacheService->clean('navigation', [
					Cache::Tags => [Navigations::CACHE_NAMESPACE],
				]);
			}
		}

		if (Config::load('allowLogCategoryShortDescChanges', false)) {
			$changeSet = $event->getObjectManager()->getUnitOfWork()->getEntityChangeSet($categoryText);

			if (isset($changeSet['shortDescription'])) {
				try {
					throw new Exception;
				} catch (Exception $e) {
					Debugger::log($e, 'categoryShortDescChanges');
					Debugger::log([
						'entityId'  => $categoryText->id->getId(),
						'changeSet' => $changeSet['shortDescription'],
					], 'categoryShortDescChanges-moreinfo');
				}
			}
		}

		self::$cleared[$categoryText->getCategory()->getId()] = true;
	}

}
