<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Contributte\Translation\Translator;
use Doctrine;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\FrontModule\Model\Features;
use Nette\Caching\Cache;
use Nette\SmartObject;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class FeatureListener implements EventSubscriberInterface
{
	use SmartObject;

	public function __construct(
		protected CacheService $cacheService,
		protected Translator   $translator,
	)
	{
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	#[ORM\PreFlush]
	public function onPreFlush(Feature|FeatureTexts $entity, Doctrine\ORM\Event\PreFlushEventArgs $args): void
	{
		$this->cacheService->defaultCache->clean([
			Cache::Tags => ['features', Features::CACHE_NAMESPACE],
		]);
		$this->cacheService->filterCache->clean([
			Cache::Tags => ['filters'],
		]);
	}

}
