<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Contributte\Translation\Translator;
use Doctrine;
use Doctrine\ORM\Event\PostRemoveEventArgs;
use Doctrine\ORM\Event\PostUpdateEventArgs;
use Doctrine\ORM\Event\PreFlushEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use Nette\Caching\Cache;
use Nette\SmartObject;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class FeatureProductListener implements EventSubscriberInterface
{
	use SmartObject;

	public function __construct(
		protected CacheService $cacheService,
		protected Translator   $translator,
	)
	{
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	#[ORM\PreFlush]
	public function onPreFlush(FeatureProduct|DynamicFeatureProduct $entity, PreFlushEventArgs $args): void
	{
		$this->cacheService->filterCache->clean([
			Cache::Tags => ['filters'],
		]);
	}

	#[ORM\PostUpdate]
	#[ORM\PostRemove]
	public function postHandler(FeatureProduct|DynamicFeatureProduct $entity, PostUpdateEventArgs|PostRemoveEventArgs $event): void
	{
		$this->cacheService->filterCache->clean([
			Cache::Tags => ['filters'],
		]);
	}

}
