<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'eshop_catalog__feature_texts')]
#[ORM\Index(columns: ['id', 'lang'], name: 'feature')]
#[ORM\Entity]
#[ORM\EntityListeners([FeatureListener::class])]
class FeatureTexts
{
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Feature::class, cascade: ['persist', 'remove'], inversedBy: 'featureTexts')]
	#[ORM\JoinColumn(name: 'id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	private Feature $id;

	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, length: 2)]
	private string $lang;

	#[ORM\Column(type: Types::STRING, length: 255)]
	public string $name;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $beaUrlMulti = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $productTabTitle = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $heurekaName = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $zboziName = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $googleName = null;

	public function __construct(Feature $id, string $lang)
	{
		$this->id   = $id;
		$this->lang = $lang;
	}

	public function getFeature(): Feature { return $this->id; }

	public function getLang(): string
	{
		return $this->lang;
	}

}
