<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Contributte\Translation\Translator;
use Doctrine;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use Nette\Caching\Cache;
use Nette\SmartObject;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class FeatureValueListener implements EventSubscriberInterface
{
	use SmartObject;

	public function __construct(
		protected CacheService $cacheService,
		protected Translator   $translator,
	)
	{
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	#[ORM\PreFlush]
	public function onPreFlush(FeatureValue|FeatureValueTexts $entity, Doctrine\ORM\Event\PreFlushEventArgs $args): void
	{
		foreach ($this->translator->getLocalesWhitelist() as $l) {
			$this->cacheService->defaultCache->remove('featureValues_' . $l);
			$this->cacheService->defaultCache->remove('featureValueTexts_' . $l);
		}

		$this->cacheService->defaultCache->remove('featureIdValues');
		$this->cacheService->defaultCache->clean([
			Cache::Tags => ['featureValues'],
		]);
		$this->cacheService->filterCache->clean([
			Cache::Tags => ['filters'],
		]);
	}

}
