<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Contributte\Translation\Translator;
use Doctrine;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use Nette\Caching\Cache;
use Nette\SmartObject;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class ManufacturerListener implements EventSubscriberInterface
{
	use SmartObject;

	protected CacheService $cacheService;
	protected Translator   $translator;

	public function __construct(CacheService $cacheService, Translator $translator)
	{
		$this->cacheService = $cacheService;
		$this->translator   = $translator;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	#[ORM\PreFlush]
	public function onPreFlush(Manufacturer|ManufacturerTexts $entity, Doctrine\ORM\Event\PreFlushEventArgs $args): void
	{
		$this->cacheService->clean('default', [
			Cache::Tags => ['manufacturers'],
		]);
	}

}
