<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TIdUnsigned;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'eshop_catalog__package')]
#[ORM\Entity]
class Package
{
	use TIdUnsigned;

	/**
	 * @var Collection<int, PackageItem>
	 */
	#[ORM\OneToMany(mappedBy: 'package', targetEntity: PackageItem::class, indexBy: 'product_id')]
	public Collection $items;

	public function __construct()
	{
		$this->items = new ArrayCollection();
	}

}
