<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;
use EshopOrders\Model\Entities\Customer;

#[ORM\Table(name: 'eshop_catalog__product_assign_customer')]
#[ORM\Entity]
class ProductAssignCustomer
{
	use TId;

	#[ORM\ManyToOne(targetEntity: Product::class)]
	#[ORM\JoinColumn(name: 'product_id', referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
	protected Product $product;

	#[ORM\ManyToOne(targetEntity: Customer::class)]
	#[ORM\JoinColumn(name: 'customer_id', referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
	protected Customer $customer;

	public function __construct(Product $product, Customer $customer)
	{
		$this->product  = $product;
		$this->customer = $customer;
	}

	public function getProduct(): Product { return $this->product; }

	public function getCustomer(): Customer { return $this->customer; }

}
