<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\Country;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use EshopOrders\Model\Entities\GroupCustomers;

#[ORM\Table(name: 'eshop_catalog__product_price_level_country')]
#[ORM\Entity]
class ProductPriceLevelCountry
{
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Product::class, inversedBy: 'priceLevelCountries')]
	#[ORM\JoinColumn(name: 'product', referencedColumnName: 'id', onDelete: 'CASCADE')]
	protected Product $product;

	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: GroupCustomers::class)]
	#[ORM\JoinColumn(name: '`group`', referencedColumnName: 'id', onDelete: 'CASCADE')]
	protected GroupCustomers $group;

	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Country::class)]
	#[ORM\JoinColumn(name: 'country', referencedColumnName: 'id', onDelete: 'CASCADE')]
	protected Country $country;

	#[ORM\Column(name: 'currency_code', type: Types::STRING, length: 255, nullable: true)]
	public ?string $currency = null;

	/**
	 * @var double|string|null
	 */
	#[ORM\Column(name: 'price', type: Types::DECIMAL, precision: 10, scale: 2, nullable: true)]
	public $price = null;

	public function __construct(Product $product, GroupCustomers $group, Country $country, ?string $currency)
	{
		$this->product  = $product;
		$this->group    = $group;
		$this->country  = $country;
		$this->currency = $currency;
	}

	public function getProduct(): Product { return $this->product; }

	public function getGroup(): GroupCustomers { return $this->group; }

	public function getCountry(): Country { return $this->country; }

	public function toArray(): array
	{
		return [
			'country'  => $this->getCountry()->getId(),
			'group'    => $this->getGroup()->getId(),
			'product'  => $this->getProduct()->getId(),
			'currency' => $this->currency,
			'price'    => $this->price,
		];
	}

}
