<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use EshopOrders\Model\Entities\Spedition;

#[ORM\Table(name: 'eshop_catalog__product_spedition')]
#[ORM\Entity]
class ProductSpedition
{
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Product::class, inversedBy: 'speditions')]
	#[ORM\JoinColumn(name: 'product_id', referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
	public Product $product;

	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Spedition::class)]
	#[ORM\JoinColumn(name: 'spedition_id', referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
	public Spedition $spedition;

	#[ORM\Column(name: 'delivery_disabled', type: Types::SMALLINT, length: 1, options: ['default' => 0])]
	public int $speditionDisabled = 0;

	public function __construct(Product $product, Spedition $spedition)
	{
		$this->product   = $product;
		$this->spedition = $spedition;
	}

}
