<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'eshop_catalog__product_supplier')]
#[ORM\Entity]
class ProductSupplier
{
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Product::class, inversedBy: 'suppliers')]
	#[ORM\JoinColumn(name: 'id_product', referencedColumnName: 'id', onDelete: 'CASCADE')]
	private Product $product;

	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Supplier::class, inversedBy: 'product')]
	#[ORM\JoinColumn(name: 'id_supplier', referencedColumnName: 'id', onDelete: 'CASCADE')]
	private Supplier $supplier;

	#[ORM\Column(type: Types::INTEGER)]
	public int $quantity;

	/**
	 * @var string
	 */
	#[ORM\Column(type: Types::STRING)]
	public string $code;

	#[ORM\ManyToOne(targetEntity: Availability::class)]
	#[ORM\JoinColumn(name: 'id_availability_after_sold_out', referencedColumnName: 'id', nullable: true, onDelete: 'SET NULL')]
	public ?Availability $availabilityAfterSoldOut = null;

	#[ORM\Column(type: Types::SMALLINT, length: 1, options: ['default' => 1])]
	public int $isActive = 1;

	#[ORM\Column(type: Types::SMALLINT, length: 1, options: ['default' => 0, 'unsigned' => true])]
	public int $mainSupplier = 0;

	public function __construct(Product $product, Supplier $supplier)
	{
		if ($product->getSuppliers()->count() === 0) {
			$this->mainSupplier = 1;
		}

		$product->getSuppliers()->add($this);
		$this->product  = $product;
		$this->supplier = $supplier;
		$this->quantity = 0;
	}

	public function getProduct(): Product { return $this->product; }

	public function setSupplier(Supplier $supplier): void { $this->supplier = $supplier; }

	public function getSupplier(): Supplier { return $this->supplier; }

}
