<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'eshop_catalog__product_tag')]
#[ORM\Index(columns: ['valid_from', 'valid_to'], name: 'valid_idx')]
#[ORM\Entity]
class ProductTag
{
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Product::class, cascade: ['persist'], inversedBy: 'ProductTags')]
	#[ORM\JoinColumn(name: 'id_product', referencedColumnName: 'id', onDelete: 'CASCADE')]
	private Product $product;

	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Tag::class)]
	#[ORM\JoinColumn(name: 'id_tag', referencedColumnName: 'id', onDelete: 'CASCADE')]
	private Tag $tag;

	/**
	 * @var \DateTimeInterface|null
	 */
	#[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
	public $validFrom;

	/**
	 * @var \DateTimeInterface|null
	 */
	#[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
	public $validTo;

	public function __construct(Product $product, Tag $tag)
	{
		$this->product = $product;
		$this->tag     = $tag;
	}

	public function setProduct(Product $product): self
	{
		$this->product = $product;

		return $this;
	}

	public function getProduct(): Product
	{
		return $this->product;
	}

	public function getTag(): Tag
	{
		return $this->tag;
	}

}
