<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Contributte\Translation\Translator;
use Doctrine;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\Model\Navigation\Home;
use Nette\Caching\Cache;
use Nette\SmartObject;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class ProductTextListener implements EventSubscriberInterface
{
	use SmartObject;

	protected static array $cleared = [];

	public function __construct(
		protected Translator   $translator,
		protected CacheService $cacheService,
	)
	{
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	#[ORM\PreFlush]
	public function onPreFlush(ProductTexts $productText, Doctrine\ORM\Event\PreFlushEventArgs $args): void
	{
		if (!self::$cleared[$productText->getProduct()->getId()]) {
			$this->cacheService->clean('product', [
				Cache::Tags => [
					'product/' . $productText->getProduct()->getId(),
				],
			]);
			$this->cacheService->clean('navigation', [
				Cache::Tags => [
					Home::CACHE_PRODUCT . '/' . $productText->getProduct()->getId(),
				],
			]);
		}

		self::$cleared[$productText->getProduct()->getId()] = true;
	}

}
