<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'eshop_catalog__product_variant_text')]
#[ORM\Entity]
class ProductVariantText
{
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: ProductVariant::class, inversedBy: 'texts')]
	#[ORM\JoinColumn(name: 'id', referencedColumnName: 'product_id', onDelete: 'CASCADE')]
	public ProductVariant $variant;

	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, length: 2, nullable: false)]
	public string $lang;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $name = null;

	public function __construct(
		ProductVariant $variant,
		string         $lang,
	)
	{
		$this->variant = $variant;
		$this->lang    = $lang;
	}

}
