<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'eshop_catalog__product_video')]
#[ORM\Entity]
class ProductVideo
{
	use TId;

	#[ORM\ManyToOne(targetEntity: Product::class)]
	#[ORM\JoinColumn(referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
	public Product $product;

	#[ORM\Column(type: Types::STRING, length: 2, nullable: true)]
	public ?string $lang = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $url = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $title = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $thumbnail = null;

	public function __construct(
		Product $product,
		?string $lang,
		?string $url,
		?string $title,
		?string $thumbnail = null,
	)
	{
		$this->product   = $product;
		$this->lang      = $lang;
		$this->url       = $url;
		$this->title     = $title;
		$this->thumbnail = $thumbnail;
	}

}
