<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'eshop_catalog__related_group_text')]
#[ORM\Entity]
class RelatedGroupText
{
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: RelatedGroup::class, cascade: ['persist', 'remove'], inversedBy: 'texts')]
	#[ORM\JoinColumn(name: 'group_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	private RelatedGroup $group;

	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, length: 2, nullable: false)]
	private string $lang;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	protected ?string $name = null;

	public function __construct(RelatedGroup $group, string $lang)
	{
		$this->group = $group;
		$this->lang  = $lang;
	}

	public function setName(string $name): self
	{
		$this->name = $name;

		return $this;
	}

	public function getName(): ?string { return $this->name; }

	public function getGroup(): RelatedGroup { return $this->group; }

	public function getLang(): string { return $this->lang; }

}
